# tempfile

> Get a random temporary file path

**Checkout out [`tempy`](https://github.com/sindresorhus/tempy) which is a better take on this module.**

## Install

```sh
npm install tempfile
```

## Usage

```js
import tempfile from 'tempfile';

tempfile();
//=> '/var/folders/3x/jf5977fn79jbglr7rk0tq4d00000gn/T/6271e235-13b9-4138-8b9b-ee2f26c09ce3'
```

## API

### tempfile(options?)

#### options

Type: `object`

##### extension

Type: `string`

A file extension to append to the path.

```js
import tempfile from 'tempfile';

tempfile();
//=> '/var/folders/3x/jf5977fn79jbglr7rk0tq4d00000gn/T/6271e235-13b9-4138-8b9b-ee2f26c09ce3'

tempfile({extension: 'png'});
//=> '/var/folders/3x/jf5977fn79jbglr7rk0tq4d00000gn/T/4049f192-43e7-43b2-98d9-094e6760861b.png'
```

## Related

- [tempy](https://github.com/sindresorhus/tempy) - Get a random temporary file or directory path
- [temp-write](https://github.com/sindresorhus/temp-write) - Write string/buffer/stream to a random temp file
