<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateWorkspaceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        if ($this->has('member_ids')) {
            return [
                'member_ids' => ['required', 'array'],
                'member_ids.*' => ['exists:users,id'],
            ];
        }

        return [
            'name' => ['required', 'max:20'],
            'description' => ['nullable', 'max:200'],
            'modules' => ['required', 'array']
        ];
    }
}
